/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.recaps;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.convertidores.BooleanNegativeConverter;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidableContexto;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteComposite;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.recap.valores.ModeloValoresPagoLocal;
import ec.gob.sri.dimm.ats.modelo.obj.recap.Recap;
import ec.gob.sri.dimm.ats.modelo.util.InfoPantallas;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.ComponenteFiscalidad;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;
import org.joda.time.LocalDate;

public class PaginaPagoLocalExterior
extends PaginaAsistente
implements VistaModelo<Recap>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private boolean editando;
    private Recap modeloDatos;
    private ModeloValoresPagoLocal modeloValores;
    private Text txtEstablecimiento;
    private Text txtPuntoEmision;
    private Text txtSecuencial;
    private Text txtNumAutorizacion;
    private Button btnConvenioSi;
    private Button btnConvenioNo;
    private Button btnRetencionSi;
    private Button btnRetencionNo;
    private ComboViewer cvPagoLocalExterior;
    private Composite compositeComprobante;
    private Composite compSecuencial;
    private Combo cmbPago;
    private Button btnSiRegFis;
    private Button btnNoRegFis;
    private final Periodo periodo;
    private Label lblRegimenFiscal;
    private Composite compositePagRegFis;
    private ComponenteFiscalidad compFiscalidad;

    public PaginaPagoLocalExterior(boolean editando, Periodo periodo) {
        super(PaginaPagoLocalExterior.class.getName(), "Anexo Transaccional", "Especifique la informaci\u00f3n correspondiente");
        this.editando = editando;
        this.periodo = periodo;
    }

    public void inicializarModeloValores() {
        LocalDate fechaDeclarada = this.periodo.getFechaDeclarada();
        this.modeloValores = new ModeloValoresPagoLocal(fechaDeclarada);
        this.modeloValores.inicializaPeriodo(this.periodo);
        this.modeloValores.inicializar();
        this.compFiscalidad = new ComponenteFiscalidad(this.modeloDatos.getPagoLocalExterior(), this.periodo);
    }

    public void procesarModeloDatos() {
        boolean esPagoANoResidente = false;
        String codigoPago = this.modeloDatos.getPagoLocalExterior().getFiscalidad().getTipoPago();
        ElementoNombreValor tipoPago = this.modeloValores.obtenerTipoPago(codigoPago);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvPagoLocalExterior, (Object)tipoPago);
        this.compFiscalidad.inicializarViews();
        if (tipoPago != null) {
            esPagoANoResidente = "02".equals(tipoPago.getValor());
            this.compFiscalidad.determinarTipoRegimen();
        }
        this.habilitarSeccionConvenioYRetencionParaPagoExterior(esPagoANoResidente);
        this.setPageComplete(!this.periodo.isPeriodoDesdeEnero2013());
        AyudanteComposite.activar((Composite)this.compositeComprobante, (boolean)true);
        AyudanteComposite.activar((Composite)this.compSecuencial, (boolean)true);
        ContextoValidacion ctxVal = new ContextoValidacion().agregar(InfoPantallas.RECAP_PAGO_LOCAL.toString(), (Object)InfoPantallas.RECAP_PAGO_LOCAL);
        ListenerValidacionModeloPaginaAsistente listener = new ListenerValidacionModeloPaginaAsistente((InformacionValidableContexto)this.modeloDatos, ctxVal, (PaginaAsistente)this);
        this.modeloDatos.getComprobanteRetencion().setObligatorio(true);
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getPagoLocalExterior().addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getPagoLocalExterior().getFiscalidad().addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getComprobanteRetencion().addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void habilitarSeccionConvenioYRetencionParaPagoExterior(boolean esPagoANoResidente) {
        if (this.periodo.isPeriodoDesdeEnero2013()) {
            this.cmbPago.setEnabled(this.periodo.isPeriodoDesdeEnero2013());
            this.btnConvenioSi.setEnabled(!esPagoANoResidente);
            this.btnConvenioNo.setEnabled(!esPagoANoResidente);
        } else if (this.periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            this.btnConvenioSi.setEnabled(esPagoANoResidente);
            this.btnConvenioNo.setEnabled(esPagoANoResidente);
        }
        this.compFiscalidad.habilitarConvenioYRetencionParaPagoExteriorModoEdicion(esPagoANoResidente);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.verticalSpacing = 2;
        container.setLayout((Layout)gl_container);
        Label lblInformacinDelPago = new Label(container, 0);
        GridData gd_lblInformacinDelPago = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblInformacinDelPago.verticalIndent = 2;
        lblInformacinDelPago.setLayoutData((Object)gd_lblInformacinDelPago);
        lblInformacinDelPago.setText("Informaci\u00f3n del Pago");
        lblInformacinDelPago.setFont(SWTResourceManager.getFont((String)"Segoe UI", (int)9, (int)1));
        new Label(container, 0);
        Label lblPagoLocalO = new Label(container, 0);
        GridData gd_lblPagoLocalO = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPagoLocalO.widthHint = 180;
        lblPagoLocalO.setLayoutData((Object)gd_lblPagoLocalO);
        lblPagoLocalO.setText("Pago a residente o no residente");
        this.cvPagoLocalExterior = new ComboViewer(container, 8);
        this.manejarSeleccionCvPagoLocalExterior();
        this.cmbPago = this.cvPagoLocalExterior.getCombo();
        GridData gd_cmbPago = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbPago.widthHint = 155;
        this.cmbPago.setLayoutData((Object)gd_cmbPago);
        this.compFiscalidad.crearComponenteFiscalidad(container, false);
        Label lblAplicaConvenioDoble = new Label(container, 0);
        GridData gd_lblAplicaConvenioDoble = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblAplicaConvenioDoble.widthHint = 210;
        lblAplicaConvenioDoble.setLayoutData((Object)gd_lblAplicaConvenioDoble);
        lblAplicaConvenioDoble.setText("\u00bfAplica convenio de doble tributaci\u00f3n?");
        Composite composite_1 = new Composite(container, 0);
        composite_1.setLayout((Layout)new GridLayout(2, false));
        this.btnConvenioSi = new Button(composite_1, 16);
        this.btnConvenioSi.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                boolean habilitar = PaginaPagoLocalExterior.this.periodo.isPeriodoDesdeEnero2018();
                PaginaPagoLocalExterior.this.btnRetencionNo.setEnabled(habilitar);
                PaginaPagoLocalExterior.this.btnRetencionSi.setEnabled(habilitar);
            }
        });
        GridData gd_btnConvenioSi = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnConvenioSi.widthHint = 50;
        this.btnConvenioSi.setLayoutData((Object)gd_btnConvenioSi);
        this.btnConvenioSi.setText("SI");
        this.btnConvenioNo = new Button(composite_1, 16);
        this.btnConvenioNo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                boolean esPagoANoResidente = "02".equals(PaginaPagoLocalExterior.this.modeloDatos.getPagoLocalExterior().getFiscalidad().getTipoPago());
                boolean habilitar = PaginaPagoLocalExterior.this.periodo.isPeriodoDesdeEnero2013() && esPagoANoResidente;
                PaginaPagoLocalExterior.this.btnRetencionNo.setEnabled(habilitar);
                PaginaPagoLocalExterior.this.btnRetencionSi.setEnabled(habilitar);
            }
        });
        GridData gd_btnConvenioNo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnConvenioNo.widthHint = 50;
        this.btnConvenioNo.setLayoutData((Object)gd_btnConvenioNo);
        this.btnConvenioNo.setText("NO");
        Label lblPagoRetencion = new Label(container, 0);
        GridData gd_lblPagoRetencion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPagoRetencion.widthHint = 342;
        lblPagoRetencion.setLayoutData((Object)gd_lblPagoRetencion);
        lblPagoRetencion.setText("\u00bfPago sujeto a retenci\u00f3n en aplicaci\u00f3n de la norma legal?");
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.btnRetencionSi = new Button(composite, 16);
        GridData gd_btnRetencionSi = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnRetencionSi.widthHint = 50;
        this.btnRetencionSi.setLayoutData((Object)gd_btnRetencionSi);
        this.btnRetencionSi.setSize(90, 16);
        this.btnRetencionSi.setText("SI");
        this.btnRetencionNo = new Button(composite, 16);
        GridData gd_btnRetencionNo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnRetencionNo.widthHint = 50;
        this.btnRetencionNo.setLayoutData((Object)gd_btnRetencionNo);
        this.btnRetencionNo.setText("NO");
        boolean verPregunta = this.compFiscalidad.visualizarEnPantalla();
        this.lblRegimenFiscal = new Label(container, 0);
        GridData gd_lblRegimenFiscal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRegimenFiscal.widthHint = 370;
        this.lblRegimenFiscal.setLayoutData((Object)gd_lblRegimenFiscal);
        this.lblRegimenFiscal.setText("\u00bfEl pago es un r\u00e9gimen fiscal preferente o de menor imposici\u00f3n?");
        this.lblRegimenFiscal.setVisible(verPregunta);
        this.compositePagRegFis = new Composite(container, 0);
        this.compositePagRegFis.setLayout((Layout)new GridLayout(2, false));
        this.btnSiRegFis = new Button(this.compositePagRegFis, 16);
        GridData gd_btnSiRegFis = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnSiRegFis.widthHint = 50;
        this.btnSiRegFis.setLayoutData((Object)gd_btnSiRegFis);
        this.btnSiRegFis.setText("SI");
        this.btnSiRegFis.setVisible(verPregunta);
        this.btnNoRegFis = new Button(this.compositePagRegFis, 16);
        GridData gd_btnNoRegFis = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnNoRegFis.widthHint = 50;
        this.btnNoRegFis.setLayoutData((Object)gd_btnNoRegFis);
        this.btnNoRegFis.setText("NO");
        this.btnNoRegFis.setVisible(verPregunta);
        Label lblComprobante = new Label(container, 0);
        GridData gd_lblComprobante = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblComprobante.verticalIndent = 5;
        lblComprobante.setLayoutData((Object)gd_lblComprobante);
        lblComprobante.setText("Comprobante de Retenci\u00f3n");
        lblComprobante.setFont(SWTResourceManager.getBoldFont((Font)lblComprobante.getFont()));
        new Label(container, 0);
        Label lblTieneComprobanteDe = new Label(container, 0);
        lblTieneComprobanteDe.setText("\u00bfTiene Comprobante de Retenci\u00f3n?");
        new Label(container, 0);
        this.compositeComprobante = new Composite(container, 0);
        GridLayout gl_compositeComprobante = new GridLayout(2, false);
        gl_compositeComprobante.marginHeight = 2;
        gl_compositeComprobante.marginWidth = 0;
        this.compositeComprobante.setLayout((Layout)gl_compositeComprobante);
        this.compositeComprobante.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.compSecuencial = new Composite(this.compositeComprobante, 0);
        this.compSecuencial.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridLayout gl_compSecuencial = new GridLayout(6, false);
        gl_compSecuencial.marginWidth = 0;
        gl_compSecuencial.marginHeight = 0;
        this.compSecuencial.setLayout((Layout)gl_compSecuencial);
        Label lblEstablecimiento = new Label(this.compSecuencial, 0);
        GridData gd_lblEstablecimiento = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblEstablecimiento.widthHint = 90;
        lblEstablecimiento.setLayoutData((Object)gd_lblEstablecimiento);
        lblEstablecimiento.setText("Establecimiento");
        this.txtEstablecimiento = new Text(this.compSecuencial, 2048);
        this.txtEstablecimiento.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaPagoLocalExterior.this.txtEstablecimiento.selectAll();
            }
        });
        this.txtEstablecimiento.setTextLimit(3);
        GridData gd_txtEstablecimiento = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtEstablecimiento.widthHint = 100;
        this.txtEstablecimiento.setLayoutData((Object)gd_txtEstablecimiento);
        Label lblPuntoEmisin = new Label(this.compSecuencial, 0);
        GridData gd_lblPuntoEmisin = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPuntoEmisin.widthHint = 80;
        lblPuntoEmisin.setLayoutData((Object)gd_lblPuntoEmisin);
        lblPuntoEmisin.setText("Punto Emisi\u00f3n");
        this.txtPuntoEmision = new Text(this.compSecuencial, 2048);
        this.txtPuntoEmision.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaPagoLocalExterior.this.txtPuntoEmision.selectAll();
            }
        });
        this.txtPuntoEmision.setTextLimit(3);
        GridData gd_txtPuntoEmision = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtPuntoEmision.widthHint = 60;
        this.txtPuntoEmision.setLayoutData((Object)gd_txtPuntoEmision);
        Label lblNSecuencial = new Label(this.compSecuencial, 0);
        GridData gd_lblNSecuencial = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblNSecuencial.widthHint = 80;
        lblNSecuencial.setLayoutData((Object)gd_lblNSecuencial);
        lblNSecuencial.setText("N\u00b0 Secuencial");
        this.txtSecuencial = new Text(this.compSecuencial, 2048);
        this.txtSecuencial.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaPagoLocalExterior.this.txtSecuencial.selectAll();
            }
        });
        this.txtSecuencial.setTextLimit(9);
        GridData gd_txtSecuencial = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtSecuencial.widthHint = 90;
        this.txtSecuencial.setLayoutData((Object)gd_txtSecuencial);
        Label lblNAutorizacinComprobante = new Label(this.compositeComprobante, 0);
        GridData gd_lblNAutorizacinComprobante = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNAutorizacinComprobante.widthHint = 190;
        lblNAutorizacinComprobante.setLayoutData((Object)gd_lblNAutorizacinComprobante);
        lblNAutorizacinComprobante.setText("N\u00b0 Autorizaci\u00f3n Comprobante");
        this.txtNumAutorizacion = new Text(this.compositeComprobante, 2048);
        this.txtNumAutorizacion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaPagoLocalExterior.this.txtNumAutorizacion.selectAll();
            }
        });
        GridData gd_txtNumAutorizacion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtNumAutorizacion.widthHint = 220;
        this.txtNumAutorizacion.setLayoutData((Object)gd_txtNumAutorizacion);
        this.txtNumAutorizacion.setTextLimit(49);
        Label lblFechaEmisinComprobante = new Label(this.compositeComprobante, 0);
        lblFechaEmisinComprobante.setText("Fecha Emisi\u00f3n Comprobante");
        final CDateTime fechaEmision = new CDateTime(this.compositeComprobante, 32771);
        GridData gd_fechaEmision = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_fechaEmision.widthHint = 133;
        fechaEmision.setLayoutData((Object)gd_fechaEmision);
        fechaEmision.setNullText("seleccione la fecha");
        fechaEmision.setPattern("dd/MM/yyyy");
        fechaEmision.setSelection(this.modeloDatos.getComprobanteRetencion().getFechaEmision());
        fechaEmision.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginaPagoLocalExterior.this.modeloDatos.getComprobanteRetencion().setFechaEmision(fechaEmision.getSelection());
            }
        });
        this.m_bindingContext = this.initDataBindings();
        this.habilitarDesabilitarRetencion();
        this.procesarModeloDatos();
    }

    private void manejarSeleccionCvPagoLocalExterior() {
        this.cvPagoLocalExterior.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoPago = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoPago != null) {
                    PaginaPagoLocalExterior.this.modeloDatos.getPagoLocalExterior().getFiscalidad().setTipoPago((String)tipoPago.getValor());
                    PaginaPagoLocalExterior.this.modeloDatos.getPagoLocalExterior().getFiscalidad().setDescripcionTipoPago(tipoPago.getNombre());
                    PaginaPagoLocalExterior.this.determinaSiEsPagoANoResidente((ElementoNombreValor<String>)tipoPago);
                }
            }
        });
    }

    private void determinaSiEsPagoANoResidente(ElementoNombreValor<String> tipoPago) {
        boolean esPagoANoResidente = "02".equals(tipoPago.getValor());
        this.habilitarSeccionPagoExterior(esPagoANoResidente);
    }

    private void habilitarSeccionPagoExterior(boolean esPagoANoResidente) {
        this.btnConvenioSi.setEnabled(esPagoANoResidente);
        this.btnConvenioNo.setEnabled(esPagoANoResidente);
        if (this.periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            this.lblRegimenFiscal.setVisible(false);
            this.btnSiRegFis.setVisible(false);
            this.btnNoRegFis.setVisible(false);
        } else {
            this.lblRegimenFiscal.setVisible(true);
            this.btnSiRegFis.setVisible(true);
            this.btnNoRegFis.setVisible(true);
            this.btnSiRegFis.setEnabled(esPagoANoResidente);
            this.btnNoRegFis.setEnabled(esPagoANoResidente);
        }
        this.compFiscalidad.habilitarPagoExteriorLuegoDeLaSeleccionDelTipoDePago(esPagoANoResidente);
        this.habilitarDesabilitarRetencion();
    }

    public void habilitarDesabilitarRetencion() {
        boolean habilita = false;
        if (this.btnConvenioSi.getSelection()) {
            habilita = false;
        }
        if (this.btnConvenioNo.getSelection()) {
            habilita = true;
        }
        this.btnRetencionSi.setEnabled(habilita);
        this.btnRetencionNo.setEnabled(habilita);
    }

    public void setModeloDatos(Recap modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtEstablecimientoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtEstablecimiento);
        IObservableValue comprobanteRetencionestablecimientoModeloDatosObserveValue = BeanProperties.value((String)"comprobanteRetencion.establecimiento").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtEstablecimientoObserveWidget, comprobanteRetencionestablecimientoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtPuntoEmisionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPuntoEmision);
        IObservableValue comprobanteRetencionpuntoEmisionModeloDatosObserveValue = BeanProperties.value((String)"comprobanteRetencion.puntoEmision").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtPuntoEmisionObserveWidget, comprobanteRetencionpuntoEmisionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtSecuencialObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtSecuencial);
        IObservableValue comprobanteRetencionsecuencialModeloDatosObserveValue = BeanProperties.value((String)"comprobanteRetencion.secuencial").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtSecuencialObserveWidget, comprobanteRetencionsecuencialModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumAutorizacionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumAutorizacion);
        IObservableValue comprobanteRetencionnumAutorizacionModeloDatosObserveValue = BeanProperties.value((String)"comprobanteRetencion.numAutorizacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumAutorizacionObserveWidget, comprobanteRetencionnumAutorizacionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionBtnConvenioSiObserveWidget = WidgetProperties.selection().observe((Widget)this.btnConvenioSi);
        IObservableValue pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue = BeanProperties.value((String)"pagoLocalExterior.convenioDobleTributacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnConvenioSiObserveWidget, pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionBtnConvenioNoObserveWidget = WidgetProperties.selection().observe((Widget)this.btnConvenioNo);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)observeSelectionBtnConvenioNoObserveWidget, pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue, strategy, strategy_1);
        ISWTObservableValue observeSelectionBtnRetencionSiObserveWidget = WidgetProperties.selection().observe((Widget)this.btnRetencionSi);
        IObservableValue pagoLocalExteriorsujetoNormaLegalModeloDatosObserveValue = BeanProperties.value((String)"pagoLocalExterior.sujetoNormaLegal").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnRetencionSiObserveWidget, pagoLocalExteriorsujetoNormaLegalModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionBtnRetencionNoObserveWidget = WidgetProperties.selection().observe((Widget)this.btnRetencionNo);
        UpdateValueStrategy strategy_2 = new UpdateValueStrategy();
        strategy_2.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
        strategy_3.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)observeSelectionBtnRetencionNoObserveWidget, pagoLocalExteriorsujetoNormaLegalModeloDatosObserveValue, strategy_2, strategy_3);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap_1 = PojoObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvPagoLocalExterior.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_1));
        this.cvPagoLocalExterior.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList tiposPagosModeloValoresObserveList = PojoProperties.list((String)"tiposPagos").observe((Object)this.modeloValores);
        this.cvPagoLocalExterior.setInput((Object)tiposPagosModeloValoresObserveList);
        ISWTObservableValue btnSiRegFisObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnSiRegFis);
        IObservableValue modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"pagoLocalExterior.pagoRegimenFiscal");
        bindingContext.bindValue((IObservableValue)btnSiRegFisObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue, null, null);
        ISWTObservableValue btnNoRegFisObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnNoRegFis);
        UpdateValueStrategy strategy_4 = new UpdateValueStrategy();
        strategy_4.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_5 = new UpdateValueStrategy();
        strategy_5.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnNoRegFisObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue, strategy_4, strategy_5);
        ISWTObservableValue cmbPagoObserveEnabledObserveWidget = SWTObservables.observeEnabled((Control)this.cmbPago);
        IObservableValue periodoPeriodoDesdeEnero2013ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"periodoDesdeEnero2013");
        bindingContext.bindValue((IObservableValue)cmbPagoObserveEnabledObserveWidget, periodoPeriodoDesdeEnero2013ObserveValue, null, null);
        ISWTObservableValue btnRetencionSiObserveEnabledObserveWidget = SWTObservables.observeEnabled((Control)this.btnRetencionSi);
        UpdateValueStrategy strategy_6 = new UpdateValueStrategy();
        strategy_6.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnRetencionSiObserveEnabledObserveWidget, pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue, null, strategy_6);
        ISWTObservableValue btnRetencionNoObserveEnabledObserveWidget = SWTObservables.observeEnabled((Control)this.btnRetencionNo);
        UpdateValueStrategy strategy_7 = new UpdateValueStrategy();
        strategy_7.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnRetencionNoObserveEnabledObserveWidget, pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue, null, strategy_7);
        bindingContext = this.compFiscalidad.initDataBindingsFiscaldiad(bindingContext, (ObjetoModelo)this.modeloDatos);
        return bindingContext;
    }
}

